<?php
include('../connect.php');

$uaFull = strtolower($_SERVER['HTTP_USER_AGENT']);
if (strpos($uaFull, 'okhttp') !== false) {

    $search = $_POST['search'] ?? '';
    $category_name = $_POST['category_name'] ?? '';
    $method = $_POST['method'] ?? '';
    $location_one = $_POST['location_one'] ?? '';
    $location_two = $_POST['location_two'] ?? '';
    $location_tree = $_POST['location_tree'] ?? '';
    
    $price_range_low = $_POST['price_range_low'];
    $price_range_high = $_POST['price_range_high'];

    if (!empty($method) && $method === "searchOption") {
        $searchParam = "%$search%";
        $categoryParam = "%$category_name%";
        $locationParamOne = "%$location_one%";
        $locationParamTwo = "%$location_two%";
        $locationParamTree = "%$location_tree%";

        $stmt = $conn->prepare("SELECT * FROM ads_table WHERE sell_status = ? AND keywords_ads LIKE ? AND category_name LIKE ? AND address_one LIKE ? AND address_two LIKE ? AND address_tree LIKE ?");
        $stmt->bind_param("ssssss", $sellStatus, $searchParam, $categoryParam, $locationParamOne, $locationParamTwo, $locationParamTree);
        $sellStatus = 'active';
        $stmt->execute();
        $result = $stmt->get_result();

        $response = array();

        if ($result->num_rows > 0) {
            while ($row = $result->fetch_assoc()) {
                $taka = $row["taka"];
                if ($price_range_low <= $taka && $taka <= $price_range_high) {
                    $response[] = $row;
                }
            }
        } else {
            echo "No results found.";
            $response = array("error" => "No results found");
        }

        echo json_encode($response);
    } else {
        echo "Invalid Request";
    }

    $stmt->close();
} else {
    echo "Invalid Request";
}
?>
